<?php
/**
 * Module Name: Simple:Press Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'sp_setup_globals' ) ) :

  //*************** Actions ***************\\
  add_action('sph_post_create', 'wpachievements_sp_add_post_topic', 10, 1);
  add_action('sph_post_delete', 'wpachievements_sp_remove_post', 10, 1);
  add_action('sph_topic_delete', 'wpachievements_sp_remove_topic', 10, 1);
  if(sp_is_plugin_active('polls/sp-polls-plugin.php')){
    add_action('sph_poll_created', 'wpachievements_sp_poll_created', 10, 2);
    add_action('sph_poll_voted', 'wpachievements_sp_do_poll_voted', 10, 3);
  }
  if(sp_is_plugin_active('post-rating/sp-rating-plugin.php')){
    add_action('sph_post_rating_add', 'wpachievements_sp_rate_post', 10, 4);
    add_action('sph_post_rating_removed', 'wpachievements_sp_rate_post_removed', 10, 3);
  }
  //*************** Detect New Post/Topic ***************\\
  function wpachievements_sp_add_post_topic($newpost){
    if($newpost['userid'] > 0){
      if($newpost['poststatus'] == 0){
        if($newpost['action'] == "post"){
          WPAchievements_Trigger::new_activity( array(
            'activity'    => 'Forum_Post',
            'user_id'     => $newpost['userid'],
            'post_id'     => '',
            'points'      => (int) wpachievements_get_site_option('wpachievements_sp_post_points'),
          ) );
        } elseif($newpost['action'] == "topic"){
          WPAchievements_Trigger::new_activity( array(
            'activity'    => 'Forum_Topic',
            'user_id'     => $newpost['userid'],
            'post_id'     => '',
            'points'      => (int) wpachievements_get_site_option('wpachievements_sp_topic_points'),
          ) );          
        }
      }
    }
  }
  //*************** Detect Forum Topic Deleted ***************\\
  function wpachievements_sp_remove_topic($posts){
    $thisTopic = (is_array($posts)) ? $posts : array(0 => $posts);
    foreach($thisTopic as $k => $post){
      if($post->user_id > 0){
        if($k == 0){
          WPAchievements_Trigger::new_activity( array(
            'activity'    => 'Forum_Topic_delete',
            'user_id'     => $post->user_id,
            'post_id'     => '',
            'points'      => -(int) wpachievements_get_site_option('wpachievements_sp_topic_points'),
          ) );     
        } else {
          WPAchievements_Trigger::new_activity( array(
            'activity'    => 'Forum_Post_delete',
            'user_id'     => $post->user_id,
            'post_id'     => '',
            'points'      => -(int) wpachievements_get_site_option('wpachievements_sp_post_points'),
          ) );     
        }
      }
    }
  }
  //*************** Detect Forum Post Deleted ***************\\
  function wpachievements_sp_remove_post($oldpost){
    if($oldpost->user_id > 0){
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'Forum_Post_delete',
        'user_id'     => $oldpost->user_id,
        'post_id'     => '',
        'points'      => -(int) wpachievements_get_site_option('wpachievements_sp_post_points'),
      ) );           
    }
  }
  //*************** Detect New Rating ***************\\
  function wpachievements_sp_rate_post($postid, $count, $sum, $user_id){
    if(sp_is_plugin_active('post-rating/sp-rating-plugin.php') && !empty($user_id)){
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'Forum_Post_rating',
        'user_id'     => $user_id,
        'post_id'     => '',
        'points'      => (int) wpachievements_get_site_option('wpachievements_sp_rate_post_points'),
      ) );  
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'Forum_Post_rated',
        'user_id'     => $user_id,
        'post_id'     => '',
        'points'      => (int) wpachievements_get_site_option('wpachievements_sp_rated_post_points'),
      ) );
    }
  }
  //*************** Detect Rating Deleted ***************\\
  function wpachievements_cp_sp_rate_post_removed($postid, $user_id){
    if(sp_is_plugin_active('post-rating/sp-rating-plugin.php') && !empty($user_id)){
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'Forum_Post_rating_delete',
        'user_id'     => $user_id,
        'post_id'     => '',
        'points'      => -(int) wpachievements_get_site_option('wpachievements_sp_rate_post_points'),
      ) );

      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'Forum_Post_rated_delete',
        'user_id'     => $user_id,
        'post_id'     => '',
        'points'      => -(int) wpachievements_get_site_option('wpachievements_sp_rated_post_points'),
      ) );      
    }
  }
  //*************** Detect New Poll ***************\\
  function wpachievements_sp_poll_created($pollid, $userid){
    if(sp_is_plugin_active('polls/sp-polls-plugin.php') && !empty($userid)){
      WPAchievements_Trigger::new_activity( array(
        'activity'    => 'Forum_Poll_create',
        'user_id'     => $userid,
        'post_id'     => '',
        'points'      => (int) wpachievements_get_site_option('wpachievements_sp_create_poll_points'),
      ) );
    }
  }
  //*************** Detect New Poll Voting ***************\\
  function wpachievements_sp_do_poll_voted( $pollid, $user_id, $creator ) {

    if ( ! function_exists( 'sp_is_plugin_active' ) || ! sp_is_plugin_active( 'polls/sp-polls-plugin.php' ) || empty( $user_id ) ) {
      return;
    }
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'Forum_Poll_vote',
      'user_id'     => $user_id,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_sp_vote_poll_points'),
    ) );
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'Forum_Poll_voted',
      'user_id'     => $creator,
      'post_id'     => '',
      'points'      => (int) wpachievements_get_site_option('wpachievements_sp_rated_post_points'),
    ) );    

  }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_sp_desc', 10, 4);
 function achievement_sp_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'Forum_Post': { $text = sprintf( _n( 'for adding %s forum post', 'for adding %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_delete': { $text = sprintf( _n( 'for deleting %s forum post', 'for deleting %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Topic': { $text = sprintf( _n( 'for adding %s forum topic', 'for adding %s forum topics', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Topic_delete': { $text = sprintf( _n( 'for deleting %s forum topic', 'for deleting %s forum topics', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rating': { $text = sprintf( _n( 'for rating %s forum post', 'for rating %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rating_delete': { $text = sprintf( _n( 'for removing %s forum post', 'for removing %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rated': { $text = sprintf( _n( 'for getting %s rating on your forum post', 'for getting %s ratings on your forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rated_delete': { $text = sprintf( _n( 'for losing %s rating on your forum post', 'for losing %s ratings on your forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Poll_create': { $text = sprintf( _n( 'for adding %s poll', 'for adding %s polls', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Poll_vote': { $text = sprintf( _n( 'for voting %s poll', 'for voting %s polls', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Poll_voted': { $text = sprintf( _n( 'for getting %s vote on your poll', 'for getting %s votes on your polls', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_sp_desc', 10, 3);
 function quest_sp_desc($text='',$type='',$times=''){
  switch($type){
   case 'Forum_Post': { $text = sprintf( _n( 'Add %s forum post', 'Add %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_delete': { $text = sprintf( _n( 'Delete %s forum post', 'Delete %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Topic': { $text = sprintf( _n( 'Add %s forum topic', 'Add %s forum topics', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Topic_delete': { $text = sprintf( _n( 'Delete %s forum topic', 'Delete %s forum topics', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rating': { $text = sprintf( _n( 'Rate %s forum post', 'Rate %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rating_delete': { $text = sprintf( _n( 'Remove %s forum post', 'Remove %s forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rated': { $text = sprintf( _n( 'Get %s rating on your forum post', 'Get %s ratings on your forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Post_rated_delete': { $text = sprintf( _n( 'Lose %s rating on your forum post', 'Lose %s ratings on your forum posts', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Poll_create': { $text = sprintf( _n( 'Add %s poll', 'Add %s polls', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Poll_vote': { $text = sprintf( _n( 'Vote on %s poll', 'Vote on %s polls', $times, 'wpachievements'), $times ); } break;
   case 'Forum_Poll_voted': { $text = sprintf( _n( 'Get %s vote on your poll', 'Get %s votes on your polls', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_sp' );
function wpachievements_add_section_sp( $sections ) {
	$sections['sp'] = __( 'Simple:Press', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_sp_admin', 10, 3);
function wpachievements_sp_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'sp' ) {
    $settings[] = array( 'title' => __( 'Simple:Press', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'SimplePress_options' );

    $settings[] = array(
            'title'   => __( 'User Adding Topics', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a topic.', 'wpachievements' ),
            'id'      => $shortname.'_sp_topic_points',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array(
            'title'   => __( 'User Adding Reply', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a topic reply.', 'wpachievements' ),
            'id'      => $shortname.'_sp_post_points',
            'type'    => 'text',
            'default' => '0',
          );
    if(sp_is_plugin_active('post-rating/sp-rating-plugin.php')){
      $settings[] = array(
            'title'   => __( 'User Adding Rating', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a rating.', 'wpachievements' ),
            'id'      => $shortname.'_sp_rate_post_points',
            'type'    => 'text',
            'default' => '0',
          );

      $settings[] = array(
            'title'   => __( 'Users Post Rated', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a post by the user gets a rating.', 'wpachievements' ),
            'id'      => $shortname.'_sp_rated_post_points',
            'type'    => 'text',
            'default' => '0',
          );
    }
    if(sp_is_plugin_active('polls/sp-polls-plugin.php')){
      $settings[] = array(
            'title'   => __( 'User Adding Poll', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user adds a poll.', 'wpachievements' ),
            'id'      => $shortname.'_sp_create_poll_points',
            'type'    => 'text',
            'default' => '0',
          );

      $settings[] = array(
            'title'   => __( 'User Adding Poll Voting', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user votes on a poll.', 'wpachievements' ),
            'id'      => $shortname.'_sp_vote_poll_points',
            'type'    => 'text',
            'default' => '0',
          );

      $settings[] = array(
            'title'   => __( 'Users Poll Voted', 'wpachievements' ),
            'desc'    => __( 'Points awarded when a poll by the user gets a vote.', 'wpachievements' ),
            'id'      => $shortname.'_sp_voted_poll_points',
            'type'    => 'text',
            'default' => '0',
          );
    }
    $settings[] = array( 'type' => 'sectionend', 'id' => 'SimplePress_options');

    return $settings;
  /**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_sp_admin_events', 10);
 function achievement_sp_admin_events(){
   echo'<optgroup label="Simple:Press Events">
     <option value="Forum_Post">'.__('The user adds a forum post', 'wpachievements').'</option>
     <option value="Forum_Topic">'.__('The user creates a forum topic', 'wpachievements').'</option>';
     if(sp_is_plugin_active('post-rating/sp-rating-plugin.php')){
       echo '<option value="Forum_Post_rating">'.__('The user rates a forum post', 'wpachievements').'</option>
       <option value="Forum_Post_rated">'.__('The users forum post is rated by another user', 'wpachievements').'</option>';
     }
     if(sp_is_plugin_active('polls/sp-polls-plugin.php')){
       echo '<option value="Forum_Poll_create">'.__('The user creates a forum poll', 'wpachievements').'</option>
       <option value="Forum_Poll_vote">'.__('The user votes in a forum poll', 'wpachievements').'</option>
       <option value="Forum_Poll_voted">'.__('The users forum poll receives a vote', 'wpachievements').'</option>';
     }
   echo '</optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_sp_admin_triggers', 1, 10);
 function achievement_sp_admin_triggers($trigger){

   switch($trigger){
     case 'Forum_Post': { $trigger = __('The user adds a forum post', 'wpachievements'); } break;
     case 'Forum_Topic': { $trigger = __('The user creates a forum topic', 'wpachievements'); } break;
     case 'Forum_Post_rating': { $trigger = __('The user rates a forum post', 'wpachievements'); } break;
     case 'Forum_Post_rated': { $trigger = __('The users forum post is rated by another user', 'wpachievements'); } break;
     case 'Forum_Poll_create': { $trigger = __('The user creates a forum poll', 'wpachievements'); } break;
     case 'Forum_Poll_vote': { $trigger = __('The user votes in a forum poll', 'wpachievements'); } break;
     case 'Forum_Poll_voted': { $trigger = __('The users forum poll receives a vote', 'wpachievements'); } break;
   }

   return $trigger;

 }
endif;
?>